@extends('layouts.master')

@section('title')
    @isset($exam->type)
        @if ($exam->type == 0)
            الاختبار القبلي
        @elseif ($exam->type == 1)
            الاختبار البعدي
        @else
            اختبار الإجتياز
        @endif
    @endisset
@endsection

@section('first-css')
@endsection

@section('header-content')
    @isset($exam->room->course->title)
        {{ $exam->room->course->title }}
    @endisset
@endsection

@section('content-body')
    <!--**********************************
                                            Content body start
                                        ***********************************-->
    @include('massages')

    <span data-expire="@isset($exam->expire){{ $exam->expire }}@endisset"
        title="@isset($exam->expire){{ $exam->expire }}@endisset" class="badge badge-primary light timer-btn"
        id="expire-time"><i class="bi bi-clock"></i></span>


    <!-- row -->
    <div class="container-fluid">
        <div class="row invoice-card-row">
            <div class="row invoice-card-row">

                <div class="col-xl-12">
                    <div class="card">
                        <div class=" d-flex d-flex justify-content-between card-header">
                            <div>
                                @isset($exam->type)
                                    @if ($exam->type == 0)
                                        <h4 class="card-title ">الاختبار القبلي </h4>
                                    @elseif ($exam->type == 1)
                                        <h4 class="card-title ">الاختبار البعدي </h4>
                                    @else
                                        <h4 class="card-title ">اختبار الإجتياز </h4>
                                    @endif
                                @endisset
                            </div>
                            <div>
                                @isset($exam->room->name)
                                    <h4 class="card-title ">{{ $exam->room->name }} برنامج {{$exam->room->course->title}}</h4>
                                @endisset
                            </div>
                        </div>

                        <div class="card-body pb-3 tran px-5">
                            <div class="form-validation">
                                <form class="validation need-validation" method="POST"
                                    action="{{ route('students_exam_store') }}">
                                    @csrf
                                    <input type="hidden" value="{{ $exam->id }}" name="examId">
                                    <input type="hidden" value="{{ Auth::id() }}" name="studentId">
                                    <div class="card-header">
                                        <h5 class="card-title ">اسئلة الاختبار</h5>
                                    </div>
                                    <div class=" all-quations   py-3 mb-2" id="allQuationts">
                                        {{-- @isset($exam->questions) --}}
                                            @foreach ($exam->questions as $question)
                                                @if ($question->type == 1)
                                                    <div class="row border p-3 my-2 quation qution-radio">
                                                        <div class="col-12 pt-4">
                                                            <label class="form-label fw-bold " for="name"><span>
                                                                    {{ $loop->iteration }} - </span>
                                                                @isset($question->question_txt)
                                                                    {{ $question->question_txt }}
                                                                @endisset *
                                                            </label>
                                                            <div class="options" style="display: block;">
                                                                <div class="row    pt-3 single-option">
                                                                    @isset($question->options)
                                                                        @foreach ($question->options as $option)
                                                                            <div
                                                                                class="col-12 col-md-12 fv-plugins-icon-container pt-2 pe-4 mb-1">
                                                                                <input required
                                                                                    class="form-check-input radio row-option mt-0 me-3"
                                                                                    type="radio"
                                                                                    name="answer[@isset($question->id){{ $question->id }}@endisset]"
                                                                                    id="exampleRadios-@isset($option->answer){{ $option->id }}@endisset"
                                                                                    value="@isset($option->id){{ $option->id }}@endisset">
                                                                                <label class=" fw-bold me-3"
                                                                                    for="exampleRadios-@isset($option->answer){{ $option->id }}@endisset">
                                                                                    @isset($option->answer)
                                                                                        {{ $option->answer }}
                                                                                    @endisset
                                                                                </label>
                                                                            </div>
                                                                        @endforeach
                                                                    @endisset
                                                                </div>
                                                            </div>
                                                            <div class="btn-delete-quation number-qution mark pt-2">
                                                                <span class=" badge badge-rounded badge-primary light">
                                                                    @isset($question->mark)
                                                                        {{ $question->mark }}
                                                                    @endisset درجات
                                                                </span>
                                                            </div>
                                                        </div>

                                                    </div>
                                                    {{-- @else
                                                <div class="row border p-3 my-2 quation qution-textarea">
                                                    <div class="col-12 pt-4">
                                                        <label class="form-label fw-bold " for="name"><span> {{ $loop->iteration }} - </span>@isset($question->question_txt){{$question->question_txt}}@endisset *</label>
                                                        <textarea required class="form-control form-white type-quation mt-2" name="answer[@isset($question->id){{$question->id}}@endisset]" rows="4" style="height: auto" placeholder="ادخل نص الاجابة هنا ...."></textarea>
                                                    </div>
                                                    <div class="btn-delete-quation number-qution mark">
                                                        <span class=" badge badge-rounded badge-primary light">
                                                            @isset($question->mark){{$question->mark}}@endisset درجات
                                                        </span>
                                                    </div>
                                                </div> --}}
                                                @endif
                                            @endforeach
                                        {{-- @endisset --}}

                                        <div class="col-xl-12" style="direction: ltr;">
                                            <button type="submit" class="btn btn-primary me-sm-3 me-1">حفظ </button>
                                        </div>
                                </form>
                            </div>

                        </div>
                    </div>

                </div>

            </div>
        </div>
    </div>
    <!--**********************************
                                            Content body end
                                ***********************************-->


@endsection

@section('script')
    <script src="{{ asset('/js/expire-exam.js') }}"></script>
    <script src="{{ asset('/vendor/datatables/js/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('/js/plugins-init/datatables.init.js') }}"></script>
@endsection
